  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:25:55 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_AES.c#1:csrc:6
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

#include "DX_VOS_Mem.h"
#include "CRYS_RND_error.h" 
#include "CRYS.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"


/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ macros *******************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/****************** Public Functions ***************************/

/* ------------------------------------------------------------
 * @brief The CRYS_RND_GenerateVector function generates a random vector,
 *			 using the FIPS-PUB [SP800-90].
 *
 *        The random function is based on the AES. The code is written according to the:
 *			 CryptoCore: Random Number Geneators System Specification (Revision 1.3)
 *
 *
 * @RndSize[in] - The size of random bytes that is required.
 *
 * @Output_ptr[in,out] The output vector.
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                        value MODULE_* as defined in ...
 */
CEXPORT_C CRYSError_t CRYS_RND_GenerateVector(DxUint16_t  RndSize,
											  DxUint8_t  *Output_ptr )
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_GENERAT_VECTOR_OP_CODE, 2,
	   							 /* PARAMETERS: */
                                 RndSize, 
								 Output_ptr );
   
}/* END OF CRYS_RND_GenerateVector */



/**********************************************************************************************************/
/* 
 * @brief The CRYS_RND_GenerateVector function generates a random vector Rand in range:
 *            1 < RandVect < MaxVect,   using the FIPS-PUB 186-2 standard appendex 3 :
 *        The function performs the following: 
 *        1.  Calls the CRYS_RND_GenerateVector() function for generating random vector 
 *            RndVect of size in bytes.
 *        2.  Zeroes extra bits of RndVect.
 *        3.  Compares RndVect with 1 and MaxVect. If condition  1 < RandVect < MaxVect
 *            is not satisfied goues to step 1.
 *
 * @RndSize[in] - The size of random vectore that is required.
 * @MaxVect_ptr[in]  - The pointer to vector defines high limit of random vector.
 * @RndVect_ptr[in,out] The output vector.
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                        value MODULE_* as defined in ...
 */
CEXPORT_C CRYSError_t CRYS_RND_GenerateVectorInRange(DxUint32_t  RndSizeInBits, 
											  DxUint8_t *MaxVect_ptr, DxUint8_t *RndVect_ptr )
{
  	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_GENERAT_VECTOR_IN_RANGE_OP_CODE, 3,
	   							 /* PARAMETERS: */
								 RndSizeInBits,
								 MaxVect_ptr,
								 RndVect_ptr );
} /* End of CRYS_RND_GenerateVectorInRange function */




/**********************************************************************************************************/
/**
 * @brief The CRYS_RND_ResetSeed resets the SEED generated by the low level ( hardware or OPerating system
 *        service on software ).  
 * This is Dummy function for backward compatbility
 *
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                        value MODULE_* as defined in ...
 */
CEXPORT_C CRYSError_t CRYS_RND_ResetSeed( void )
{
  	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_RESET_SEED_OP_CODE, 0
	   							 /* PARAMETERS: */
								);
}/* END OF CRYS_RND_ResetSeed */

